﻿using System;

namespace Microscopic_Traffic_Simulator___Model.SimulationControl
{
    /// <summary>
    /// Every class which performs some repeating action should implement this interface
    /// </summary>
    interface ISimulationEventsGenerator
    {
        /// <summary>
        /// Method for getting time to next action from the implementing class
        /// </summary>
        /// <param name="random">Random instance for cases that the resulting time would be
        /// result of random variables</param>
        /// <returns></returns>
        TimeSpan GetTimeToNextAction(Random random);

        /// <summary>
        /// Method for action which is performed by the implementing class
        /// </summary>
        /// <param name="random">Random instance for case that action depends on random
        /// variables</param>
        void PerformAction(Random random);

        /// <summary>
        /// Check whether the simulation action generator has the pause scheduled.
        /// </summary>
        bool IsPauseScheduled { get; }

        /// <summary>
        /// Priority determining the rank of the events which have the same time.
        /// </summary>
        int Priority { get; }
    }
}
